' DnK Dairy Queen - Store Selector GUI
' Click your store button to run reports

Option Explicit

Dim objShell, fso, scriptPath
Set objShell = CreateObject("WScript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")
scriptPath = fso.GetParentFolderName(WScript.ScriptFullName)

' Create the message box with store buttons
Dim title, message, result
title = "DnK Dairy Queen - Store Selector"
message = "Select Your Store:" & vbCrLf & vbCrLf & _
          "Click a button to run your store's report:" & vbCrLf & vbCrLf & _
          "1. PLUM (Store #19556)" & vbCrLf & _
          "2. MURRYSVILLE (Store #17863)" & vbCrLf & _
          "3. INDIANA (Store #16210)" & vbCrLf & _
          "4. NEW KENSINGTON (Store #19091)" & vbCrLf & vbCrLf & _
          "Which store do you want to run?"

' Show input box for store selection
result = InputBox(message, title, "1")

If result = "" Then
    WScript.Quit
End If

' Convert to number and run appropriate report
Dim batFile, storeName
Select Case result
    Case "1"
        batFile = "Run-Plum-Report.bat"
        storeName = "PLUM"
    Case "2"
        batFile = "Run-Murrysville-Report.bat"
        storeName = "MURRYSVILLE"
    Case "3"
        batFile = "Run-Indiana-Report.bat"
        storeName = "INDIANA"
    Case "4"
        batFile = "Run-NewKensington-Report.bat"
        storeName = "NEW KENSINGTON"
    Case Else
        MsgBox "Invalid choice! Please enter 1, 2, 3, or 4.", vbExclamation, "Error"
        WScript.Quit
End Select

' Check if batch file exists
Dim fullPath
fullPath = scriptPath & "\" & batFile

If Not fso.FileExists(fullPath) Then
    MsgBox "Error: Cannot find " & batFile & vbCrLf & vbCrLf & _
           "Make sure all files are in the same folder.", vbCritical, "File Not Found"
    WScript.Quit
End If

' Run the report
objShell.Run """" & fullPath & """", 1, False

MsgBox storeName & " report started!" & vbCrLf & vbCrLf & _
       "Wait 30-60 seconds." & vbCrLf & _
       "Dashboard will open automatically when complete.", vbInformation, "Report Running"
