@echo off
title D&K Dairy Queen - Indiana Store Report
color 0A

echo.
echo ========================================
echo   D^&K DAIRY QUEEN - INDIANA REPORT
echo   Store #16210
echo ========================================
echo.
echo Fetching sales data from ParBrink...
echo.

node run-report.js indiana 16210 "Indiana"

IF %ERRORLEVEL% EQU 0 (
    echo.
    echo Report complete! Opening dashboard...
    echo.

    REM Start server in background
    start /B npx http-server -p 8080 >nul 2>&1
    timeout /t 2 /nobreak >nul

    REM Open dashboard in browser
    start "" http://localhost:8080/dashboard.html

    echo.
    echo ========================================
    echo   DASHBOARD OPENED IN YOUR BROWSER
    echo ========================================
    echo.
    echo This window will auto-close in 30 seconds.
    echo The dashboard will stay open in your browser.
    echo Close the browser tab when done to stop the server.
    echo.
    echo Press any key to close now, or wait 30 seconds...

    REM Wait 30 seconds or until user presses a key
    timeout /t 30

    echo.
    echo Closing... Server will stop when you close the browser.
    echo.
    timeout /t 2 /nobreak >nul
    exit
) ELSE IF %ERRORLEVEL% EQU 2 (
    echo.
    echo ========================================
    echo   PASSWORD ERROR DETECTED
    echo ========================================
    echo.
    echo The username or password is incorrect!
    echo.
    echo TO FIX THIS:
    echo   1. Open the .env file in this folder
    echo   2. Update PARBRINK_USERNAME and PARBRINK_PASSWORD
    echo   3. Run this report again
    echo.
    echo ========================================
    echo.
    pause
) ELSE (
    echo.
    echo ========================================
    echo   ERROR: Report Failed
    echo ========================================
    echo.
    echo Please check your internet connection and try again.
    echo.
    pause
)
