' D&K Dairy Queen Reports Launcher
' Interactive GUI for selecting which store report to run

Set objShell = CreateObject("WScript.Shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

' Get the directory where this script is located
strScriptPath = objFSO.GetParentFolderName(WScript.ScriptFullName)

' Create the menu prompt
strMessage = "D&K DAIRY QUEEN - NIGHTLY REPORTS" & vbCrLf & vbCrLf & _
             "Select which store to run:" & vbCrLf & vbCrLf & _
             "1 = Plum (Store #19556)" & vbCrLf & _
             "2 = Murrysville (Store #17863)" & vbCrLf & _
             "3 = Indiana (Store #16210)" & vbCrLf & _
             "4 = New Kensington (Store #19091)" & vbCrLf & _
             "5 = Password Manager (Fix Login Issues)" & vbCrLf & vbCrLf & _
             "Enter 1, 2, 3, 4, or 5:"

' Show input box
strChoice = InputBox(strMessage, "D&K DQ Reports - Store Selection")

' Process the choice
Select Case strChoice
    Case "1"
        objShell.CurrentDirectory = strScriptPath
        objShell.Run "Run-Plum-Report.bat", 1, False
    Case "2"
        objShell.CurrentDirectory = strScriptPath
        objShell.Run "Run-Murrysville-Report.bat", 1, False
    Case "3"
        objShell.CurrentDirectory = strScriptPath
        objShell.Run "Run-Indiana-Report.bat", 1, False
    Case "4"
        objShell.CurrentDirectory = strScriptPath
        objShell.Run "Run-NewKensington-Report.bat", 1, False
    Case "5"
        ' Run password manager from parent folder
        strParentPath = objFSO.GetParentFolderName(strScriptPath)
        strPasswordManager = strParentPath & "\parbrink-password-manager\npm.cmd run dev"
        objShell.CurrentDirectory = strParentPath & "\parbrink-password-manager"
        objShell.Run "cmd /c npm run dev", 1, False
    Case Else
        If strChoice <> "" Then
            MsgBox "Invalid selection. Please run the launcher again and choose 1, 2, 3, 4, or 5.", vbExclamation, "Invalid Choice"
        End If
End Select
